import React from 'react';
import { connect } from 'react-redux';
import get from 'lodash/get';
import redux from '../../redux';
import List from './List';

class ListContainer extends React.Component {
  componentDidMount() {
    this.promise = this.props.get();
  }

  componentWillUnmount() {
    this.promise.cancel();
  }

  render() {
    const { listState, get: listGet, ...props } = this.props;

    const items = get(listState, 'data.types', []).map((item) => ({
      title: item.title,
      value: item.code,
    }));

    return <List {...props} items={items} />;
  }
}

export default connect(
  (state) => ({
    listState: redux.selectors.list(state) || {},
  }),
  { get: redux.actions.list.get },
)(ListContainer);
