import * as React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import CheckButton from 'lego/components/CheckButton';
import PinGroup from 'lego/components/PinGroup';
import { Value, Scheme } from '../../types';

interface Props {
  className?: string;
  scheme: Scheme;
  event: string;
  role: string;
  onChange?: (value: boolean, e: Event) => void;
  controlType?: string;
  value: Value;
  disabled: boolean;
}

const getValue = (props: Props, method: string): boolean => {
  try {
    return props.value[props.event][props.role].includes(method);
  } catch (e) {
    return false;
  }
};

const GroupControl = (props: Props): React.ReactElement => {
  const { className, scheme, event, role, onChange, controlType, disabled = false } = props;

  return (
    <span className={className}>
      <PinGroup>
        {disabled ? (
          <Button theme="clear" disabled>
            Не применимо
          </Button>
        ) : (
          scheme.methods.map((item) => (
            <CheckButton
              key={item.code}
              onChange={onChange}
              value={getValue(props, item.code)}
              data-control-type={controlType}
              data-method={item.code}
              data-event={event}
              data-role={role}
              size="xs"
            >
              {item.title}
            </CheckButton>
          ))
        )}
      </PinGroup>
    </span>
  );
};

export default GroupControl;
