export default ({ actionTypes }) => {
  const actions = {
    module: {
      destroy: () => ({ type: actionTypes.module.DESTROY }),
    },
    list: {
      get() {
        return {
          type: 'FETCH',
          actions: [
            actionTypes.list.get.REQUEST,
            actionTypes.list.get.RECEIVE,
            actionTypes.list.get.FAIL,
          ],
          args: {
            url: '/usersettings/notificationSettings',
            type: 'GET',
          },
        };
      },
    },
    form: {
      destroy: () => ({ type: actionTypes.form.DESTROY }),
      get(code) {
        return {
          type: 'FETCH',
          actions: [
            actionTypes.form.get.REQUEST,
            actionTypes.form.get.RECEIVE,
            actionTypes.form.get.FAIL,
          ],
          args: {
            url: `/usersettings/notificationSettings/${code}`,
            type: 'GET',
          },
        };
      },
      post(code, value) {
        return {
          type: 'FETCH',
          json: true,
          actions: [
            actionTypes.form.post.REQUEST,
            actionTypes.form.post.RECEIVE,
            actionTypes.form.post.FAIL,
          ],
          args: {
            url: `/usersettings/notificationSettings/${code}`,
            type: 'POST',
            data: {
              value,
            },
          },
        };
      },
    },
  };

  return actions;
};
