import createActionTypes from './createActionTypes';
import createActions from './createActions';
import createReducer from './createReducer';
import createSelectors from './createSelectors';

const createRedux = path => {
  if (createRedux.redux) {
    return createRedux.redux;
  }

  const actionTypes = createActionTypes(path);
  const selectors = createSelectors(path);

  const actions = createActions({
    actionTypes,
    selectors,
  });

  const result = {
    actionTypes,
    actions,
    reducer: createReducer(actionTypes),
    selectors,
  };

  window.reduxStore.injectReducer(path, result.reducer);

  createRedux.redux = result;
  return result;
};

export default createRedux('settingsModule/notifications');
