export interface Event {
  code: string;
  controlType: string;
  title: string;
}

export interface Method {
  code: string;
  title: string;
}

export interface Role {
  code: string;
  title: string;
  disabledEventsCodes?: string[];
}

export interface Scheme {
  events: Event[];
  methods: Method[];
  roles: Role[];
}

export interface Value {
  [key: string]: { [key: string]: string[] };
}

export interface BackendResponse {
  value: Value;
  scheme: Scheme;
}
