import { jsonApiCall, apiCall } from 'api/common';
import createI18N from '@yandex-int/i18n';
import * as keyset from './other.i18n';
import * as aTypes from './actionTypes';

const i18n = createI18N(keyset);
const i18nLangConfirm = i18n('langConfirm');

export const getUserSettings = () => ({
  type: 'PROMISE',
  promise: apiCall('/view/usersettings/common'),
  actions: [
    aTypes.GET_USER_SETTINGS_REQUEST,
    aTypes.GET_USER_SETTINGS_RECEIVE,
    aTypes.GET_USER_SETTINGS_FAIL,
  ],
});

export const saveUserLang = ({ lang }) => {
  const currentLang = localStorage.getItem('userLanguage');
  if (currentLang === lang) {
    return {
      type: aTypes.SAVE_USER_LANGUAGE,
    };
  }

  localStorage.setItem('userLanguage', lang);
  if (!confirm(i18nLangConfirm)) {
    return {
      type: aTypes.SAVE_USER_LANGUAGE,
    };
  }

  location.reload();
  return {
    type: aTypes.SAVE_USER_LANGUAGE,
  };
};

export const saveUserSettings = values => dispatch => {
  dispatch({
    type: 'PROMISE',
    promise: jsonApiCall({
      url: '/actions/usersettings/common/save',
      data: values,
    }),
    actions: [
      aTypes.SAVE_USER_SETTINGS_REQUEST,
      aTypes.SAVE_USER_SETTINGS_RECEIVE,
      aTypes.SAVE_USER_SETTINGS_FAIL,
    ],
  });
  dispatch(saveUserLang(values));
};
