import React from 'react';
import TitleChain from 'modules/heading';
import createI18N from '@yandex-int/i18n';
import { MODULE_NAME as SettingsModule } from 'modules/settings/constants';
import SettingsForm from '../SettingsForm';
import css from './styles.modules.scss';
import * as keyset from '../../other.i18n';

const i18nOther = createI18N(keyset)('other');

const Layout = props => {
  if (!props.isLoad) {
    return null;
  }

  return (
    <div className={css.wrap}>
      <TitleChain>{i18nOther}</TitleChain>
      <div className={css.path}>
        {SettingsModule} → {i18nOther}
      </div>
      <div className={css.addresses}>
        <SettingsForm
          initialValues={props.data}
          onSubmit={props.saveUserSettings}
          enableReinitialize
        />
      </div>
    </div>
  );
};

export default Layout;
