import React from 'react';
import { FormProps } from 'react-final-form';
import { Form, FieldRow } from 'components/FinalForm';
import createI18N, { Language } from '@yandex-int/i18n';
import * as keyset from '../other.i18n';

const i18n = createI18N(keyset);
const i18nMarkEmailRead = i18n('markEmailRead');
const i18nManual = i18n('manual');
const i18nOnOpen = i18n('onOpen');
const i18nOnReply = i18n('onReply');
const i18nLangRussian = i18n('langRussian');
const i18nLangEnglish = i18n('langEnglish');
const i18nLangLabel = i18n('langLabel');

const langs = [
  {
    value: 'ru',
    content: i18nLangRussian,
  },
  {
    value: 'en',
    content: i18nLangEnglish,
  },
];

const initialLang = (localStorage.getItem('userLanguage') as Language) || 'ru';

interface InitialValues {
  lang: Language;
}

type Props = FormProps<InitialValues>;

const SettingsForm: React.FC<Props> = props => {
  const { onSubmit, initialValues } = props;

  const initValues = {
    ...initialValues,
    lang: initialLang,
  };

  return (
    <Form onSubmit={onSubmit} initialValues={initValues} footerAlign="start">
      <FieldRow
        name="support.emailReadingType"
        component="Select"
        label={i18nMarkEmailRead}
        options={[
          { value: 'Manual', content: i18nManual },
          { value: 'OnOpen', content: i18nOnOpen },
          { value: 'OnReply', content: i18nOnReply },
        ]}
      />
      <FieldRow name="lang" component="Select" label={i18nLangLabel} options={langs} />
    </Form>
  );
};

export default SettingsForm;
