import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import get from 'lodash/get';
import reducer from '../reducer';
import { NAME } from '../constants';
import * as actions from '../actions';
import Layout from '../components/Layout';

global.reduxStore.injectReducer(NAME, reducer);

const mapState = state => ({ ...get(state, NAME) });

class SettingsOtherLayout extends Component {

  componentDidMount() {
    this.props.getUserSettings();
  }

  render() {
    return <Layout {...this.props} />;
  }
}

export default connect(mapState, actions)(SettingsOtherLayout);

SettingsOtherLayout.propTypes = {
  getUserSettings: PropTypes.func.isRequired,
};
