import * as t from './actionTypes.js';
import { baseCallApi } from 'api/common';

const NAMES_SIGNATURES_RESET = t.NAMES_SIGNATURES_RESET;
export const resetData = () => ({
  type: NAMES_SIGNATURES_RESET,
});

const NAMES_SIGNATURES_REQUEST = t.NAMES_SIGNATURES_LOAD + '_REQUEST';
const NAMES_SIGNATURES_RECIEVE = t.NAMES_SIGNATURES_LOAD + '_RECIEVE';
const NAMES_SIGNATURES_FAIL = t.NAMES_SIGNATURES_LOAD + '_FAIL';
export const loadData = () => ({
  type: 'PROMISE',
  actions: [NAMES_SIGNATURES_REQUEST, NAMES_SIGNATURES_RECIEVE, NAMES_SIGNATURES_FAIL],
  promise: baseCallApi({
    url: '/view/usersettings/emailsettings',
    host: CRM_SPACE_API_HOST,
  }),
});

const NAMES_SET = t.NAMES_SET;
export const setNames = data => ({
  type: NAMES_SET,
  emails: data,
});

const NAMES_RESET = t.NAMES_RESET;
export const resetNames = () => ({
  type: NAMES_RESET,
});

const NAMES_EDIT = t.NAMES_EDIT;
export const editNames = emailId => ({
  type: NAMES_EDIT,
  emailId,
});

const NAMES_CANCEL = t.NAMES_CANCEL;
export const cancelNames = emailId => ({
  type: NAMES_CANCEL,
  emailId,
});

const NAMES_POST_REQUEST = t.NAMES_SAVE + '_REQUEST';
const NAMES_POST_RECIEVE = t.NAMES_SAVE + '_RECIEVE';
const NAMES_POST_FAIL = t.NAMES_SAVE + '_FAIL';
export const saveNames = data => ({
  type: 'PROMISE',
  actions: [NAMES_POST_REQUEST, NAMES_POST_RECIEVE, NAMES_POST_FAIL],
  promise: baseCallApi({
    url: '/actions/usersettings/mailaddress/edit',
    host: CRM_SPACE_API_HOST,
    type: 'post',
    data,
  }),
  args: data,
});

const COPY_SET = t.COPY_SET;
export const setCopies = data => ({
  type: COPY_SET,
  data,
});

const COPY_RESET = t.COPY_RESET;
export const resetCopies = () => ({
  type: COPY_RESET,
});

const COPY_EDIT = t.COPY_EDIT;
export const editCopies = () => ({
  type: COPY_EDIT,
});

const COPY_CANCEL = t.COPY_CANCEL;
export const cancelCopies = () => ({
  type: COPY_CANCEL,
});

const COPY_POST_REQUEST = t.COPY_SAVE + '_REQUEST';
const COPY_POST_RECIEVE = t.COPY_SAVE + '_RECIEVE';
const COPY_POST_FAIL = t.COPY_SAVE + '_FAIL';
export const saveCopies = data => ({
  type: 'PROMISE',
  actions: [COPY_POST_REQUEST, COPY_POST_RECIEVE, COPY_POST_FAIL],
  promise: baseCallApi({
    url: '/actions/usersettings/mailaddress/bcc/edit',
    host: CRM_SPACE_API_HOST,
    type: 'post',
    data,
  }),
  args: data,
});

const SIGNATURE_RESET = t.SIGNATURE_RESET;
export const resetSignature = () => ({
  type: SIGNATURE_RESET,
});

const SIGNATURE_ADD = t.SIGNATURE_ADD;
export const addSignature = () => ({
  type: SIGNATURE_ADD,
});

const SIGNATURE_EDIT = t.SIGNATURE_EDIT;
export const editSignature = (id, data) => ({
  type: SIGNATURE_EDIT,
  data,
  id,
});

const SIGNATURE_POST_REQUEST = t.SIGNATURE_SAVE + '_REQUEST';
const SIGNATURE_POST_RECIEVE = t.SIGNATURE_SAVE + '_RECIEVE';
const SIGNATURE_POST_FAIL = t.SIGNATURE_SAVE + '_FAIL';
export const saveSignature = data => ({
  type: 'PROMISE',
  actions: [SIGNATURE_POST_REQUEST, SIGNATURE_POST_RECIEVE, SIGNATURE_POST_FAIL],
  promise: baseCallApi({
    url: '/actions/usersettings/mailsignature/save',
    host: CRM_SPACE_API_HOST,
    type: 'post',
    data,
  }),
  args: data,
});

const SIGNATURE_DELETE_REQUEST = t.SIGNATURE_DELETE + '_REQUEST';
const SIGNATURE_DELETE_RECIEVE = t.SIGNATURE_DELETE + '_RECIEVE';
const SIGNATURE_DELETE_FAIL = t.SIGNATURE_DELETE + '_FAIL';
export const deleteSignature = signatureId => ({
  type: 'PROMISE',
  actions: [SIGNATURE_DELETE_REQUEST, SIGNATURE_DELETE_RECIEVE, SIGNATURE_DELETE_FAIL],
  promise: baseCallApi({
    url: '/actions/usersettings/mailsignature/delete',
    host: CRM_SPACE_API_HOST,
    type: 'post',
    data: { signatureId },
  }),
});
