import React from 'react';
import PropTypes from 'prop-types';
import Names from '../Names';
import Copies from '../Copies';

const SettingsMailAddresses = (props) => {
  const {
    className,
    names,
    copies,
    editNames,
    editCopies,
  } = props;

  return (
    <div className={className}>
      <Names
        emails={names.emails}
        editList={names.isEdit}
        editNames={editNames}
      />
      <Copies
        data={copies.data}
        isEdit={copies.isEdit}
        editCopies={editCopies}
      />
    </div>
  );
};

SettingsMailAddresses.propTypes = {
  className: PropTypes.string,
  names: PropTypes.shape({
    isEdit: PropTypes.number,
  }),
  copies: PropTypes.shape({
    isEdit: PropTypes.bool,
  }),
  editNames: PropTypes.func,
  editCopies: PropTypes.func,
};

SettingsMailAddresses.defaultProps = {
  className: undefined,
  names: {},
  copies: {},
  editNames: () => {},
  editCopies: () => {},
};

export default SettingsMailAddresses;
