import React from 'react';
import PropTypes from 'prop-types';
import { Field } from 'redux-form';
import TextInput from 'lego/redux-form/TextInput';
import Button from '@crm/components/dist/lego2/Button';
import Icon from 'lego/components/Icon';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import css from '../Addresses/styles.modules.scss';

const commonI18n = createI18N(commonKeyset);
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');

const MailCopiesForm = (props) => {
  const { initialValues, emails, change, cancelCopies, submitting, invalid, handleSubmit } = props;

  return (
    <form className={css.editCopy} onSubmit={handleSubmit}>
      <Field name="emails" component={TextInput} type="text" size="xs" />
      &nbsp;
      <Button
        type="submit"
        size="xs"
        view="action"
        disabled={submitting || invalid}
        title={i18nSave}
        icon={(iconCls) => <Icon className={iconCls} pack="material" icon="done" />}
      />
      <Button
        size="xs"
        view="pseudo"
        disabled={submitting}
        title={i18nCancel}
        onClick={() => {
          if (!emails || !emails.length || invalid) {
            change('emails', initialValues.emails);
          }
          cancelCopies();
        }}
        icon={(iconCls) => <Icon className={iconCls} pack="material" icon="close" />}
      />
    </form>
  );
};

MailCopiesForm.propTypes = {
  initialValues: PropTypes.instanceOf(Object),
  emails: PropTypes.string,
  change: PropTypes.func.isRequired,
  cancelCopies: PropTypes.func.isRequired,
  handleSubmit: PropTypes.func.isRequired,
  submitting: PropTypes.bool,
  invalid: PropTypes.bool,
};

MailCopiesForm.defaultProps = {
  initialValues: {},
  emails: undefined,
  emailAddressId: undefined,
  copy: {},
  submitting: undefined,
  invalid: undefined,
};

export default MailCopiesForm;
