import React from 'react';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import Icon from 'lego/components/Icon';
import css from '../Addresses/styles.modules.scss';

const i18nChange = createI18N(commonKeyset)('change');

const MailCopiesPreview = (args) => {
  const { emails, editCopies } = args;

  return (
    <>
      <span className={css.name}>{emails || '–'}</span>
      &nbsp;
      <span className={css.editCopy}>
        <Button
          view="pseudo"
          title={i18nChange}
          onClick={editCopies}
          size="xs"
          icon={(iconCls) => <Icon className={iconCls} pack="material" icon="edit" />}
        />
      </span>
    </>
  );
};

MailCopiesPreview.propTypes = {
  emails: PropTypes.string,
  editCopies: PropTypes.func.isRequired,
};

MailCopiesPreview.defaultProps = {
  emails: undefined,
};

export default MailCopiesPreview;
