import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import Form from '../../containers/CopiesForm';
import Preview from './Preview';
import css from '../Addresses/styles.modules.scss';
import * as keyset from './Copies.i18n';

const i18n = createI18N(keyset);
const i18nCopyLabel = i18n('copyLabel');
const i18nHint = i18n('hint');

const MailCopies = args => {
  const { data, isEdit, editCopies } = args;

  return (
    <div className={css.copies}>
      <div className={css.rows}>
        <div className={css.row}>
          <div className={cx(css.rowLabel, css.copiesLabel)}>{i18nCopyLabel}</div>
          <div className={css.rowField}>
            {isEdit ? (
              <Form
                key="SettingsMailCopies"
                form="SettingsMailCopies"
                initialValues={{ emails: data.emails }}
              />
            ) : (
              <Preview emails={data.emails} editCopies={editCopies} />
            )}
          </div>
        </div>
      </div>
      <div className={css.hint}>{i18nHint}</div>
    </div>
  );
};

MailCopies.propTypes = {
  data: PropTypes.shape({
    emails: PropTypes.string,
  }),
  editCopies: PropTypes.func,
};

MailCopies.defaultProps = {
  data: {},
  editCopies: () => {},
};

export default MailCopies;
