import React from 'react';
import PropTypes from 'prop-types';
import RouterLink from 'components/RouterLink';
import createI18N from '@yandex-int/i18n';
import { MODULE_NAME as SettingsModule } from 'modules/settings/constants';
import * as keyset from './Layout.i18n';
import { ROUTE } from '../../constants';
import Addresses from '../../containers/Addresses';
import Signatures from '../SignaturesList';
import Tip from '../Tip';
import css from './styles.modules.scss';

const i18n = createI18N(keyset);
const i18nSignaturesTitle = i18n('signaturesTitle');
const i18nTitle = i18n('title');
const i18nNewSignature = i18n('newSignature');

const SettingsSignaturesLayout = props => {
  const { allData, signature, children } = props;

  if (!allData.isLoad) return null;

  const { signatures, emailAddressId, emails, displayName, bccEmails } = allData.data;

  return (
    <div className={css.root}>
      <div className={css.path}>
        {SettingsModule} → {i18nSignaturesTitle}
      </div>
      <div className={css.addresses}>
        <div className={css.title}>{i18nTitle}</div>
        <Addresses
          className={css.addressData}
          data={{ emailAddressId, emails, displayName, bccEmails }}
        />
      </div>
      <div className={css.signatures}>
        <div className={css.signaturesTitle}>
          {i18nSignaturesTitle}
          <RouterLink className={css.add} activeClassName={css.addActive} to={`${ROUTE}/new`}>
            <i className="material-icons">add_box</i>
            {i18nNewSignature}
          </RouterLink>
        </div>
        <div className={css.signaturesData}>
          <div className={css.signaturesList}>
            {signatures && signatures.length > 0 && <Signatures items={signatures} />}
          </div>
          <div className={css.signaturesItem}>
            <Tip allData={allData} signature={signature} />
            {children}
          </div>
        </div>
      </div>
    </div>
  );
};

SettingsSignaturesLayout.propTypes = {
  signature: PropTypes.shape({
    data: PropTypes.instanceOf(Object),
  }),
  allData: PropTypes.shape({
    data: PropTypes.instanceOf(Object),
  }),
};

SettingsSignaturesLayout.defaultProps = {
  signature: {
    data: {},
  },
  allData: {
    data: {},
  },
};

export default SettingsSignaturesLayout;
