import React from 'react';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button';
import Icon from 'lego/components/Icon';
import TextInput from 'lego/redux-form/TextInput';
import { Field } from 'redux-form';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import * as keyset from './Names.i18n';
import css from './styles.modules.scss';

const commonI18n = createI18N(commonKeyset);
const i18nMainEmail = createI18N(keyset)('mainEmail');
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');
const i18nChange = commonI18n('change');

const NameRowForm = (props) => {
  const {
    isMain,
    email,
    displayName,
    emailAddressId,
    isEdit,
    editNames,
    cancelNames,
    submitting,
    invalid,
    handleSubmit,
    reset,
    size,
  } = props;

  return (
    <form className={cx(css.row)} onSubmit={handleSubmit}>
      <div className={cx(css.cell, css.cell_email)}>
        {isMain ? <span className={cx('fa fa-star', css.star)} title={i18nMainEmail} /> : null}
        {email}
      </div>
      <div className={cx(css.cell, css.cell_name, { [css.row__edit]: isEdit })}>
        {isEdit ? (
          <span className={css.editName}>
            <Field name="displayName" component={TextInput} type="text" size={size} autoFocus />
          </span>
        ) : (
          <span className={css.name}>{displayName || '–'}</span>
        )}
      </div>
      <div className={cx(css.cell, css.cell_controls)}>
        {isEdit ? (
          <span className={css.editName}>
            <Button
              type="submit"
              view="action"
              disabled={submitting || invalid}
              title={i18nSave}
              size={size}
              icon={(iconCls) => <Icon className={iconCls} pack="material" icon="done" />}
            />
            <Button
              view="pseudo"
              disabled={submitting}
              title={i18nCancel}
              size={size}
              onClick={() => {
                reset();
                cancelNames(emailAddressId);
              }}
              icon={(iconCls) => <Icon className={iconCls} pack="material" icon="close" />}
            />
          </span>
        ) : (
          <span className={css.editName}>
            <Button
              view="pseudo"
              key="edit"
              title={i18nChange}
              onClick={() => editNames(emailAddressId)}
              size={size}
              icon={(iconCls) => <Icon className={iconCls} pack="material" icon="edit" />}
            />
          </span>
        )}
      </div>
    </form>
  );
};

NameRowForm.propTypes = {
  editNames: PropTypes.func.isRequired,
  isEdit: PropTypes.bool,
  size: PropTypes.string,
};

NameRowForm.defaultProps = {
  isEdit: false,
  editNames: () => {},
  size: 'xs',
};

export default NameRowForm;
