import React from 'react';
import PropTypes from 'prop-types';
import NameRow from '../../containers/NamesRow';
import css from './styles.modules.scss';

const SettingsMailNames = (props) => {
  const {
    emails,
    editList,
    editNames,
  } = props;

  return (
    <div className={css.root}>
      {
        emails.map(email =>
          <NameRow
            email={email}
            isEdit={editList && editList == email.emailAddressId}
            key={`SettingsEmailAddressForm_${email.emailAddressId}`}
            form={`SettingsEmailAddressForm_${email.emailAddressId}`}
            initialValues={email}
            enableReinitialize
            editNames={editNames}
          />)
      }
    </div>
  );
};

SettingsMailNames.propTypes = {
  emails: PropTypes.arrayOf(PropTypes.shape({
    displayName: String,
    emailAddressId: Number,
    email: String,
    isMain: Boolean,
  })),
  editNames: PropTypes.func.isRequired,
};

SettingsMailNames.defaultProps = {
  emails: [],
  editNames: () => {},
};

export default SettingsMailNames;
