import React from 'react';
import PropTypes from 'prop-types';
import { Field } from 'redux-form';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import CheckBox from 'lego/redux-form/CheckBox';
import RichTextEditor from 'lego/redux-form/RichTextEditor';
import * as keyset from './SignatureForm.i18n';
import css from './styles.modules.scss';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nTitle = i18n('title');
const i18nNewSignature = i18n('newSignature');
const i18nDefaultSignature = i18n('defaultSignature');
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');
const i18nRemove = commonI18n('remove');

const SettingsMailSignature = (props) => {
  const { handleSubmit, submitting, invalid, onDelete, onReset, size } = props;
  const { id } = props.initialValues;

  return (
    <form className={css.form} onSubmit={handleSubmit}>
      <div className={css.block}>
        <div className={css.header}>
          <label htmlFor="body" className={cx(css.label, css.requiredStar)}>
            {i18nTitle}
          </label>
          {!id ? <span className={css.isNew}>{i18nNewSignature}</span> : null}
        </div>
        <div className={css.editor}>
          <Field
            name="body"
            id="body"
            component={RichTextEditor}
            config="mail"
            props={{
              height: 'fix',
              keepLinesInPlainText: true,
            }}
          />
        </div>
      </div>
      <div className={css.block}>
        <Field name="isDefault" component={CheckBox} className={css.isDefault} size={size}>
          {i18nDefaultSignature}
        </Field>
      </div>
      <div className={css.actions}>
        <span>
          <Button type="submit" view="action" size={size} disabled={submitting || invalid}>
            {i18nSave}
          </Button>
          <Button view="pseudo" size={size} disabled={submitting} onClick={onReset}>
            {i18nCancel}
          </Button>
        </span>
        {id ? (
          <Button view="pseudo" size={size} disabled={submitting} onClick={onDelete}>
            {i18nRemove}
          </Button>
        ) : null}
      </div>
    </form>
  );
};

SettingsMailSignature.propTypes = {
  id: PropTypes.number,
  onSubmit: PropTypes.func.isRequired,
  onDelete: PropTypes.func,
  onReset: PropTypes.func,
  size: PropTypes.string,
};

SettingsMailSignature.defaultProps = {
  id: undefined,
  onDelete: () => {},
  onReset: () => {},
  size: 'm',
};

export default SettingsMailSignature;
