import React from 'react';
import PropTypes from 'prop-types';
import RouterLink from 'components/RouterLink';
import createI18N from '@yandex-int/i18n';
import { ROUTE } from '../../constants';
import css from './styles.modules.scss';
import * as keyset from './SignaturesList.i18n';

const i18nDefaultSignature = createI18N(keyset)('defaultSignature');

const MailSignatures = (props) => {
  const { items } = props;
  return items.length ? (
    <div className={css.list}>
      {items.map((item) => {
        const itemBody = () => ({ __html: item.body });

        return (
          <RouterLink
            key={item.id}
            className={css.listItem}
            activeClassName={css.listItemCurrent}
            to={`${ROUTE}/${item.id}`}
          >
            {item.isDefault ? (
              <span className={css.listItemDefault}>{i18nDefaultSignature}</span>
            ) : null}
            <span dangerouslySetInnerHTML={itemBody()} />
          </RouterLink>
        );
      })}
    </div>
  ) : null;
};

MailSignatures.propTypes = {
  items: PropTypes.arrayOf(PropTypes.object),
};

MailSignatures.defaultProps = {
  items: [],
};

export default MailSignatures;
