import React from 'react';
import PropTypes from 'prop-types';
import RouterLink from 'components/RouterLink';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import * as keyset from './Tip.i18n';
import { ROUTE } from '../../constants';
import css from '../Layout/styles.modules.scss';

const i18n = createI18N(keyset);
const i18nRaw = createI18NRaw(keyset);
const i18nSomethingGoesWrong = createI18N(commonKeyset)('somethingGoesWrong');
const i18nAddNew1 = i18n('addNew', { count: 1 });
const i18nAddNew2 = i18n('addNew', { count: 2 });
const i18nNoSignaturesYet = i18nRaw('noSignaturesYet', {
  optionalAction: <RouterLink to={`${ROUTE}/new`}>{i18nAddNew1}</RouterLink>,
});
const i18nSignatureCreated = i18n('signatureCreated');
const i18nSignatureSaved = i18n('signatureSaved');
const i18nSignatureRemoved = i18n('signatureRemoved');
const i18nChooseSignature = i18nRaw('chooseSignature', {
  optionalAction: <RouterLink to={`${ROUTE}/new`}>{i18nAddNew2}</RouterLink>,
});

const SettingsSignaturesTip = props => {
  const { allData, signature } = props;
  const allDataSignatures = allData.data && allData.data.signatures ? allData.data.signatures : [];

  if (!allData.isLoad) return null;
  if (!signature.isNew && !signature.isEdit && (signature.isError || allData.isError)) {
    return <div className={css.tip}>{i18nSomethingGoesWrong}</div>;
  }
  if (!allDataSignatures.length && !signature.isEdit && !signature.isNew) {
    return <div className={css.tip}>{i18nNoSignaturesYet}</div>;
  }
  if (signature.isSave && !signature.data.id) {
    return <div className={css.tip}>{i18nSignatureCreated}</div>;
  }
  if (signature.isSave) {
    return <div className={css.tip}>{i18nSignatureSaved}</div>;
  }
  if (signature.isDelete) {
    return <div className={css.tip}>{i18nSignatureRemoved}</div>;
  }
  if (!signature.isEdit && !signature.isNew) {
    return <div className={css.tip}>{i18nChooseSignature}</div>;
  }
  return null;
};

SettingsSignaturesTip.propTypes = {
  signature: PropTypes.shape({
    data: PropTypes.instanceOf(Object),
  }),
  allData: PropTypes.shape({
    data: PropTypes.instanceOf(Object),
  }),
};

SettingsSignaturesTip.defaultProps = {
  signature: {
    data: {},
  },
  allData: {
    data: {},
  },
};

export default SettingsSignaturesTip;
