import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { NAME } from '../constants';
import * as actions from '../actions';
import Addresses from '../components/Addresses';

const mapState = (state, props) => ({
  copies: get(state, `${NAME}.copies`),
  names: get(state, `${NAME}.names`),
});

const mapDispatch = (dispatch, props) => ({
  setNames: data => dispatch(actions.setNames(data)),
  setCopies: data => dispatch(actions.setCopies(data)),
  editNames: emailId => dispatch(actions.editNames(emailId)),
  editCopies: () => dispatch(actions.editCopies()),
  resetNames: () => dispatch(actions.resetNames()),
  resetCopies: () => dispatch(actions.resetCopies()),
});

class SettingsMailAddresses extends Component {
  componentWillMount() {
    const {
      data: { bccEmails, emails },
    } = this.props;

    this.props.setNames(emails);
    this.props.setCopies({ emails: bccEmails });
  }

  componentWillUnmount() {
    this.props.resetNames();
    this.props.resetCopies();
  }

  render() {
    return <Addresses {...this.props} />;
  }
}

SettingsMailAddresses.propTypes = {
  data: PropTypes.shape({
    emailAddressId: PropTypes.number,
    emails: PropTypes.arrayOf(PropTypes.object),
    displayName: PropTypes.string,
    bccEmails: PropTypes.string,
  }),
};

SettingsMailAddresses.defaultProps = {
  data: {},
};

export default connect(mapState, mapDispatch)(SettingsMailAddresses);
