import { connect } from 'react-redux';
import get from 'lodash/get';
import { reduxForm, formValueSelector } from 'redux-form';
import * as patterns from 'requestForms/utils/patterns';
import createI18N from '@yandex-int/i18n';
import * as constants from '../constants';
import * as actions from '../actions';
import CopiesForm from '../components/Copies/Form';
import * as keyset from '../signatures.i18n';

const i18nEmailsError = createI18N(keyset)('emailsError');

const validate = values => {
  const errors = {};

  if (values.emails && !patterns.emailsCorp.test(values.emails)) {
    errors.emails = i18nEmailsError;
  }

  return errors;
};

const mapState = (state, props) => {
  const formName = props.form;
  const selector = formValueSelector(formName);
  const { emails, emailAddressId } = selector(state, 'emails', 'emailAddressId');

  return {
    emails,
    emailAddressId,
    copy: get(state, constants.NAME).copy,
  };
};

const mapDispatch = (dispatch, props) => ({
  onSubmit: data => {
    if (props.initialValues.emails !== data.emails) {
      const post = { emails: data.emails };

      dispatch(actions.saveCopies(post)).then(response => {
        if (!response.success) {
          dispatch(actions.cancelCopies());
        }
      });
    } else {
      dispatch(actions.cancelCopies());
    }
  },
  cancelCopies: () => dispatch(actions.cancelCopies()),
});

export default connect(mapState, mapDispatch)(reduxForm({ validate })(CopiesForm));
