import React, { Component } from 'react';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { NAME } from '../constants';
import * as actions from '../actions';
import reducers from '../reducers';
import Layout from '../components/Layout';

global.reduxStore.injectReducer(NAME, reducers);

const mapState = state => ({
  allData: get(state, `${NAME}.load`),
  signature: get(state, `${NAME}.signature`),
});

const mapDispatch = dispatch => ({
  loadData: () => dispatch(actions.loadData()),
  resetData: () => dispatch(actions.resetData()),
});

class SettingsSignaturesLayout extends Component {
  componentWillMount() {
    this.props.loadData();
  }

  componentWillUnmount() {
    this.props.resetData();
  }

  render() {
    return <Layout {...this.props} />;
  }
}

export default connect(mapState, mapDispatch)(SettingsSignaturesLayout);
