import React, { Component } from 'react';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { reduxForm, formValueSelector } from 'redux-form';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import { NAME } from '../constants';
import * as actions from '../actions';
import NameRowForm from '../components/Names/Row';

const i18nRequired = createI18N(commonKeyset)('inputRequired');

const validate = values => {
  const errors = {};

  if (!values.displayName || !values.displayName.length) {
    errors.displayName = i18nRequired;
  }

  return errors;
};

const mapState = (state, props) => {
  const formName = props.form;
  const selector = formValueSelector(formName);
  const { displayName, emailAddressId, email, isMain } = selector(
    state,
    'displayName',
    'emailAddressId',
    'isMain',
    'email',
  );

  return {
    isMain,
    email,
    displayName,
    emailAddressId,
    names: get(state, `${NAME}.names`),
  };
};

const mapDispatch = dispatch => ({
  onSubmit: data => dispatch(actions.saveNames(data)),
  onSubmitSuccess: () => dispatch(actions.cancelNames()),
  cancelNames: emailId => dispatch(actions.cancelNames(emailId)),
});

class SettingsNameRow extends Component {
  componentWillUpdate(nextProps) {
    if (this.props.isEdit && nextProps.isEdit !== this.props.isEdit) {
      this.props.reset();
    }
  }

  render() {
    return <NameRowForm {...this.props} />;
  }
}

export default connect(mapState, mapDispatch)(reduxForm({ validate })(SettingsNameRow));
