import React, { Component } from 'react';
import { connect } from 'react-redux';
import get from 'lodash/get';
import routeController from 'modules/settings/utils/routeController';
import { NAME, ROUTE } from '../constants';
import * as actions from '../actions';
import SignatureForm from './SignatureForm';

const mapState = state => ({
  allData: get(state, `${NAME}.load`),
  signature: get(state, `${NAME}.signature`),
});

const mapDispatch = dispatch => ({
  addSignature: () => dispatch(actions.addSignature()),
  editSignature: (id, data) => dispatch(actions.editSignature(id, data)),
  resetSignature: () => dispatch(actions.resetSignature()),
});

class SettingsSignature extends Component {
  constructor(props) {
    super(props);

    this.routeController = routeController({
      add: props.addSignature,
      edit: id => {
        props.editSignature(id, get(props, 'allData.data.signatures'));
      },
      reset: () => {
        const { resetSignature, router } = props;

        resetSignature();
        router.push(ROUTE);
      },
    });
  }

  componentDidMount() {
    const { id } = this.props.routeParams;

    this.routeController({
      isNew: id === 'new',
      id,
    });
  }

  componentWillReceiveProps(newProps) {
    if (newProps.routeParams.id !== this.props.routeParams.id) {
      const { id } = newProps.routeParams;

      this.routeController({
        isNew: id === 'new',
        id,
      });
    }
  }

  componentWillUnmount() {
    this.props.resetSignature();
  }

  render() {
    const { signature, router } = this.props;

    if (!signature.isNew && !signature.isEdit) return null;

    const formName = `SettingsMailSignature${(signature.data && signature.data.id) || 'New'}`;

    return (
      <SignatureForm
        key={formName}
        form={formName}
        initialValues={signature.data}
        router={router}
      />
    );
  }
}

export default connect(mapState, mapDispatch)(SettingsSignature);
