import { connect } from 'react-redux';
import { reduxForm } from 'redux-form';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import { ROUTE } from '../constants';
import * as actions from '../actions';
import Signature from '../components/SignatureForm';
import * as keyset from '../signatures.i18n';

const i18nRequired = createI18N(commonKeyset)('inputRequired');
const i18nRemoveConfirm = createI18N(keyset)('removeConfirm');

const validate = values => {
  const errors = {};
  const requiredFields = ['body'];

  requiredFields.forEach(field => {
    if (!values[field] || (values[field].hasOwnProperty('length') && !values[field].length)) {
      errors[field] = i18nRequired;
    }
  });

  return errors;
};

const mapDispatch = (dispatch, props) => {
  const loadData = () => dispatch(actions.loadData());

  return {
    onSubmit: data => {
      const signature = Object.assign({}, data);

      signature.signatureId = signature.id;
      delete signature.id;

      dispatch(actions.saveSignature(signature)).then(response => {
        if (response.success === true) {
          return loadData().then(data => {
            props.router.push(ROUTE);
            return data;
          });
        }

        return response;
      });
    },
    onDelete: () => {
      const { id } = props.initialValues;
      const result = confirm(i18nRemoveConfirm);

      if (!result) return;

      dispatch(actions.deleteSignature(id)).then(response => {
        if (response.success === true) {
          return loadData().then(data => {
            props.router.push(ROUTE);
            return data;
          });
        }

        return response;
      });
    },
    onReset: () => {
      dispatch(actions.resetSignature());
      props.router.push(ROUTE);
    },
  };
};

export default connect(null, mapDispatch)(reduxForm({ validate })(Signature));
