import {combineReducers} from 'redux';
import * as t from './actionTypes';

const load = (state = {}, action) => {
  switch (action.type) {
    case t.NAMES_SIGNATURES_RESET:
      return {};

    case t.NAMES_SIGNATURES_LOAD + '_REQUEST':
      return {
        ...state,
        isFetch: true,
      };
    case t.NAMES_SIGNATURES_LOAD + '_RECIEVE':
      return {
        ...state,
        data: action.data,
        isLoad: true,
        isFetch: false,
        isError: false,
      };
    case t.NAMES_SIGNATURES_LOAD + '_FAIL':
      return {
        ...state,
        isFetch: false,
        isError: true,
      };
    default:
      return state;
  }
}

const names = (state = {}, action) => {
  switch (action.type) {
    case t.NAMES_RESET:
      return {};
    case t.NAMES_SET:
      return {
        ...state,
        emails: action.emails,
        isEdit: null,
        isSave: false,
        isReset: false,
        isError: false,
      };
    case t.NAMES_EDIT:
      return {
        ...state,
        isEdit: action.emailId,
        isSave: false,
        isReset: false,
      };
    case t.NAMES_CANCEL:
      return {
        ...state,
        isEdit: null,
      };
    case t.NAMES_SAVE + '_REQUEST':
      return {
        ...state,
        isFetch: true,
      };
    case t.NAMES_SAVE + '_RECIEVE':
      return {
        ...state,
        emails: state.emails
          .map(e => e.emailAddressId == action.args.emailAddressId
            ? { ...e, displayName: action.args.displayName }
            : e),
        responce: action.data,
        isFetch: false,
        isEdit: null,
        isSave: true,
        isReset: false,
        isError: false,
      };
    case t.NAMES_SAVE + '_FAIL':
      return {
        ...state,
        isFetch: false,
        isSave: false,
        isError: true,
      };
    default:
      return state;
  }
};

const copies = (state = {}, action) => {
  switch (action.type) {
    case t.COPY_RESET:
      return {};
    case t.COPY_SET:
      return {
        ...state,
        data: action.data,
        isEdit: false,
        isSave: false,
        isReset: false,
        isError: false,
      };
    case t.COPY_EDIT:
      return {
        ...state,
        isEdit: true,
        isSave: false,
        isReset: false,
      };
    case t.COPY_CANCEL:
      return {
        ...state,
        isEdit: false,
      };
    case t.COPY_SAVE + '_REQUEST':
      return {
        ...state,
        isFetch: true,
      };
    case t.COPY_SAVE + '_RECIEVE':
      return {
        ...state,
        data: action.args,
        responce: action.data,
        isFetch: false,
        isEdit: false,
        isSave: true,
        isReset: false,
        isError: false,
      };
    case t.COPY_SAVE + '_FAIL':
      return {
        ...state,
        isFetch: false,
        isSave: false,
        isError: true,
      };
    default:
      return state;
  }
}

const signature = (state = {}, action) => {
  switch (action.type) {
    case t.SIGNATURE_RESET:
      return {};

    case t.SIGNATURE_ADD:
      return {
        ...state,
        data: {},
        isNew: true,
        isEdit: false,
        isSave: false,
        isDelete: false,
        isReset: false,
      };
    case t.SIGNATURE_EDIT:
      const result = {
        ...state,
        isNew: false,
        isSave: false,
        isDelete: false,
        isReset: false,
      };
      let editSignature;

      action.data.some((item) => {
        const result = item.id === action.id;

        if (result) {
          editSignature = item;
        }

        return result;
      });

      if (editSignature) {
        result.data = editSignature;
        result.isEdit = true;
        result.isError = false;
      } else {
        result.isEdit = false;
        result.isError = true;
      }

      return result;
    case t.SIGNATURE_SAVE + '_REQUEST':
      return {
        ...state,
        isFetch: true,
      };
    case t.SIGNATURE_SAVE + '_RECIEVE':
      const saveSignature = { ...action.args, id: action.args.signatureId };
      delete saveSignature.signatureId;

      return {
        ...state,
        data: saveSignature,
        responce: action.data,
        isFetch: false,
        isNew: false,
        isEdit: false,
        isSave: true,
        isDelete: false,
        isReset: false,
        isError: false,
      };
    case t.SIGNATURE_SAVE + '_FAIL':
      return {
        ...state,
        isFetch: false,
        isSave: false,
        isError: true,
      };
    case t.SIGNATURE_DELETE + '_REQUEST':
      return {
        ...state,
        isFetch: true,
      };
    case t.SIGNATURE_DELETE + '_RECIEVE':
      return {
        ...state,
        responce: action.data,
        isFetch: false,
        isNew: false,
        isEdit: false,
        isSave: false,
        isDelete: true,
        isReset: false,
        isError: false,
      };
    case t.SIGNATURE_DELETE + '_FAIL':
      return {
        ...state,
        isFetch: false,
        isDelete: false,
        isError: true,
      };
    default:
      return state;
  }
}

export default combineReducers({ load, names, copies, signature });
