import React from 'react';
import { Route } from 'react-router-dom';
import TitleChain from 'modules/heading';
import { moduleAuthorization } from 'modules/authorization/moduleAuthorization';
import createI18N from '@yandex-int/i18n';
import Layout from './containers/Layout';
import Signature from './containers/Signature';
import * as keyset from './signatures.i18n';

const i18nTitle = createI18N(keyset)('title');

const Auth = moduleAuthorization('settingsAccess.signatures')(Layout);

const SignatureAdapter = ({ match, history }) => (
  <Signature params={match.params} routeParams={match.params} router={history} />
);

const SignatureRouter = ({ match }) => (
  <Auth>
    <TitleChain>{i18nTitle}</TitleChain>
    <Route path={`${match.url}/:id`} component={SignatureAdapter} />
  </Auth>
);

export default SignatureRouter;
