import { jsonApiCall, apiCall } from 'api/common';
import * as aTypes from './actionTypes';

export const getUserSettings = () => ({
  type: 'PROMISE',
  promise: apiCall('/view/usersettings/common'),
  actions: [
    aTypes.GET_USER_SETTINGS_REQUEST,
    aTypes.GET_USER_SETTINGS_RECEIVE,
    aTypes.GET_USER_SETTINGS_FAIL,
  ],
});

export const saveUserSettings = values => ({
  type: 'PROMISE',
  promise: jsonApiCall({
    url: '/actions/usersettings/common/save',
    data: values,
  }),
  actions: [
    aTypes.SAVE_USER_SETTINGS_REQUEST,
    aTypes.SAVE_USER_SETTINGS_RECEIVE,
    aTypes.SAVE_USER_SETTINGS_FAIL,
  ],
});
