import React from 'react';
import PropTypes from 'prop-types';
import createI18N from '@yandex-int/i18n';
import TitleChain from 'modules/heading';
import { MODULE_NAME as SettingsModule } from 'modules/settings/constants';
import SettingsForm from './SettingsForm';
import { NAME } from '../constants';
import Wrap from './Wrap';
import Path from './Path';
import * as keyset from '../supports.i18n';

const i18n = createI18N(keyset);
const i18nQueues = i18n('queues');

class Layout extends React.Component {
  componentDidMount() {
    this.props.getUserSettings();
  }

  render() {
    if (!this.props.isLoad) {
      return null;
    }

    return (
      <Wrap>
        <TitleChain>{i18nQueues}</TitleChain>
        <Path>{`${SettingsModule} → ${i18nQueues}`}</Path>
        <SettingsForm
          form={NAME}
          initialValues={this.props.data}
          onSubmit={this.props.saveUserSettings}
          enableReinitialize
        />
      </Wrap>
    );
  }
}

Layout.propTypes = {
  getUserSettings: PropTypes.func.isRequired,
  saveUserSettings: PropTypes.func.isRequired,
  isLoad: PropTypes.bool,
  data: PropTypes.objectOf(PropTypes.any),
};

Layout.defaultProps = {
  isLoad: false,
  data: undefined,
};

export default Layout;
