import React from 'react';
import { apiCall } from 'api/common';
import Select from 'lego/redux-form/Select';

class Printers extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      items: [],
      isLoad: false,
    };
  }

  componentDidMount() {
    apiCall('/view/dicts/printer').then(data => {
      this.setState({
        items: data.items ? data.items.map(item => ({ value: item, content: item })) : [],
        isLoad: true,
      });
    });
  }

  render() {
    if (!this.state.isLoad) {
      return null;
    }

    return <Select {...this.props} options={this.state.items} />;
  }
}

export default Printers;
