import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './style.modules.scss';

const Row = (props) => {
  const { label, children, className, ...passThroughProps } = props;

  return (
    <div className={cx(className, css.Row)} {...passThroughProps}>
      {
        label &&
        <span className={css.Row__label}>{label}</span>
      }
      <div className={css.Row__label}>
        {children}
      </div>
    </div>
  );
};

Row.propTypes = {
  label: PropTypes.node,
  className: PropTypes.string,
  children: PropTypes.node,
};

Row.defaultProps = {
  label: undefined,
  children: undefined,
  className: undefined,
};

export default Row;
