import React from 'react';
import PropTypes from 'prop-types';
import createI18N from '@yandex-int/i18n';
import { Field, reduxForm, propTypes } from 'redux-form';
import CheckBox from 'lego/redux-form/CheckBox';
import Button from '@crm/components/dist/lego2/Button';
import * as commonKeyset from 'common.i18n';
import Actions from './Actions';
import Row from './Row';
import Printers from './Printers';
import * as keyset from '../supports.i18n';

const i18n = createI18N(keyset);
const commonI18n = createI18N(commonKeyset);
const i18nOpenLastMail = i18n('openLastMail');
const i18nHideTickets = i18n('hideTickets');
const i18nDefaultPrinter = i18n('defaultPrinter');
const i18nSave = commonI18n('save');

const SettingsForm = (props) => {
  const { handleSubmit, pristine, submitting, size } = props;
  return (
    <form onSubmit={handleSubmit}>
      <Row>
        <Field name="support.openFirstMail" component={CheckBox} size={size}>
          {i18nOpenLastMail}
        </Field>
      </Row>
      <Row>
        <Field name="support.hideTicketsTimeline" component={CheckBox} size={size}>
          {i18nHideTickets}
        </Field>
      </Row>
      <Row label={i18nDefaultPrinter}>
        <Field name="support.printerName" component={Printers} size={size} />
      </Row>
      <Actions>
        <Button view="action" type="submit" disabled={pristine || submitting} size={size}>
          {i18nSave}
        </Button>
      </Actions>
    </form>
  );
};

SettingsForm.propTypes = {
  ...propTypes,
  size: PropTypes.string,
};

SettingsForm.defaultProps = {
  size: 'm',
};

export default reduxForm()(SettingsForm);
