import * as aTypes from './actionTypes';

const behaviors = {
  [aTypes.GET_USER_SETTINGS_RECEIVE](state, { data }) {
    return {
      ...state,
      isLoad: true,
      data,
    };
  },
  [aTypes.SAVE_USER_SETTINGS_RECEIVE](state, { data }) {
    return {
      ...state,
      data,
    };
  },
};

export default (state = {}, action) => {
  const behavior = behaviors[action.type];
  if (behavior) {
    return behavior(state, action);
  }

  return state;
};
