import React from 'react';
import Wrap from 'modules/settings/modules/supports/components/Wrap';
import Path from 'modules/settings/modules/supports/components/Path';
import createI18N from '@yandex-int/i18n';
import { config } from 'services/Config';
import TitleChain from 'modules/heading';
import { MODULE_NAME as SettingsModule } from 'modules/settings/constants';

import { TerminalTypeDropdown } from './TerminalTypeDropdown';
import { SoftPhoneInfo } from './SoftPhoneInfo';
import { WebPhoneInfo } from './WebPhoneInfo';
import { Provider, TerminalTypeService } from './services/TerminalTypeService';

import * as keyset from '../../telephony.i18n';

const i18n = createI18N(keyset);
const i18nTelephony = i18n('telephony');

export const Layout = () => {
  const useYaCallsLB = config.value.features.useYaCallsLB;
  const useExternalPhone = config.value.useExternalPhone;

  return (
    <Provider value={new TerminalTypeService()}>
      <Wrap>
        <TitleChain>{i18nTelephony}</TitleChain>
        <Path>
          {SettingsModule} → {i18nTelephony}
        </Path>
        {useYaCallsLB && <TerminalTypeDropdown />}
        {useExternalPhone && useYaCallsLB && <SoftPhoneInfo />}
        {!useExternalPhone && <WebPhoneInfo />}
      </Wrap>
    </Provider>
  );
};
