import React from 'react';
import CopyButton from 'lego/components/CopyButton';
import { LabelTextProps } from './LabelText.types';
import css from './LabelText.module.css';

export const LabelText: React.FC<LabelTextProps> = ({ label, text }) => {
  return (
    <div className={css.LabelText}>
      <div className={css.LabelText__label}>{label}</div>
      <div className={css.LabelText__textContainer}>
        <div className={css.LabelText__text}>{text}</div>
        {text && (
          <CopyButton
            copy={text}
            className={css.LabelText__copyButton}
            iconClassName={css.LabelText__copyButtonIcon}
            title="Скопировать текст"
            tooltipText="Текст скопирован"
            withTooltip
            tooltipCloseDelay={1500}
            size="xs"
            view="clear"
            stopPropagation
          />
        )}
      </div>
    </div>
  );
};
