import React, { useEffect, useContext } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import createI18N from '@yandex-int/i18n';
import { observer } from 'mobx-react-lite';
import Spinner from 'components/Spinner';
import { context } from '../services/TerminalTypeService';
import css from './SoftPhoneInfo.module.css';
import { LabelText } from './LabelText';

import * as keyset from '../../../telephony.i18n';

const i18n = createI18N(keyset);
const i18nLogin = i18n('login');
const i18nPassword = i18n('password');
const i18nTcpPort = i18n('tcpPort');
const i18nTlsPort = i18n('tlsPort');
const i18nHost = i18n('host');
const i18nChangePassword = i18n('changePassword');

export const SoftPhoneInfo = observer(() => {
  const terminalTypeService = useContext(context);

  if (!terminalTypeService) {
    return null;
  }

  useEffect(() => {
    terminalTypeService.getSoftPhoneInfo();
  }, []);

  return (
    <div className={css.SoftPhoneInfo}>
      <LabelText label={i18nLogin} text={terminalTypeService.softPhoneInfo?.login} />
      <LabelText label={i18nPassword} text={terminalTypeService.softPhoneInfo?.password} />
      <LabelText label={i18nTcpPort} text={terminalTypeService.softPhoneInfo?.tcpPort} />
      <LabelText label={i18nTlsPort} text={terminalTypeService.softPhoneInfo?.tlsPort} />
      <LabelText label={i18nHost} text={terminalTypeService.softPhoneInfo?.host} />
      <Button size="m" onClick={terminalTypeService.resetSoftPhonePassword}>
        {i18nChangePassword}
      </Button>
      {terminalTypeService.isSoftPhoneInfoLoading && (
        <div className={css.SoftPhoneInfo__spin}>
          <Spinner visible modal={false} />
        </div>
      )}
    </div>
  );
});
