import React, { useContext } from 'react';
import Select from '@crm/components/dist/lego2/Select';
import Spin from '@crm/components/dist/lego2/Spin';
import createI18N from '@yandex-int/i18n';
import { config } from 'services/Config';
import { observer } from 'mobx-react-lite';
import { TerminalTypes } from '../services/TerminalTypeService/TerminalTypeService.types';
import css from './TerminalTypeDropdown.module.css';
import { context } from '../services/TerminalTypeService';
import { TerminalTypeNames } from './TerminalTypeDropdown.constants';

import * as keyset from '../../../telephony.i18n';

const i18n = createI18N(keyset);
const i18nSelectTerminal = i18n('selectTerminal');

export const TerminalTypeDropdown = observer(() => {
  const terminalTypeService = useContext(context);

  if (!terminalTypeService) {
    return null;
  }

  const useExternalPhone = config.value.useExternalPhone;
  const phoneSelectOptions = Object.keys(TerminalTypes).map((type) => ({
    value: type,
    content: TerminalTypeNames[type],
  }));

  const getTerminalType = () => {
    return useExternalPhone ? TerminalTypes.SOFTPHONE : TerminalTypes.WEBPHONE;
  };

  return (
    <div className={css.TerminalTypeDropdown}>
      <span className={css.TerminalTypeDropdown__label}>{i18nSelectTerminal}</span>
      <Select
        size="m"
        view="default"
        hasEmptyValue={false}
        value={getTerminalType()}
        onChange={terminalTypeService.setTerminalType}
        options={phoneSelectOptions}
        className={css.TerminalTypeDropdown__select}
        disabled={terminalTypeService.isTerminalTypeLoading}
      />
      <Spin
        className={css.TerminalTypeDropdown__spin}
        progress={terminalTypeService.isTerminalTypeLoading}
        view="default"
        size="xxs"
      />
    </div>
  );
});
