import React, { useContext } from 'react';
import { useDispatch } from 'react-redux';
import Button from '@crm/components/dist/lego2/Button';
import createI18N from '@yandex-int/i18n';
import { webphoneContext } from 'modules/webphone/components/WebphoneContext/WebphoneContext';
import { actions } from 'modules/userStatus';
import { UserStatusId } from 'types/UserStatusId';

import { InfoTextBlock } from 'components/InfoTextBlock';
import css from './WebPhoneInfo.module.css';

import * as keyset from '../../../telephony.i18n';

const i18n = createI18N(keyset);
const i18nWarningText = i18n('warningText');
const i18nSetupWebphoneMessage = i18n('setupWebphoneMessage');
const i18nShowWebphoneButtonText = i18n('showWebphoneButtonText');

export const WebPhoneInfo = () => {
  const webphone = useContext(webphoneContext);
  const dispatch = useDispatch();

  const handleShowWebphoneClick = () => {
    if (!webphone) {
      return;
    }

    dispatch(actions.setStatusByStatusId(UserStatusId.disconnected));
    webphone.switchVisibility(true);
  };

  return (
    <React.Fragment>
      <div>{i18nSetupWebphoneMessage}</div>
      <Button size="m" onClick={handleShowWebphoneClick}>
        {i18nShowWebphoneButtonText}
      </Button>
      <InfoTextBlock
        theme="warning"
        text={i18nWarningText}
        className={css.WebPhoneInfo__infoText}
      />
    </React.Fragment>
  );
};
