import { makeAutoObservable } from 'mobx';
import {
  SoftPhoneInfoData,
  TerminalTypeServiceInterface,
  TerminalTypes,
} from './TerminalTypeService.types';

export const sofftPhoneInfoStub: SoftPhoneInfoData = {
  login: 'login',
  password: 'password',
  tcpPort: 111,
  tlsPort: 222,
  host: 'host',
};
export const newPasswordStub: Pick<SoftPhoneInfoData, 'password'> = { password: 'newpassword' };
export const terminalTypeStub: TerminalTypes = TerminalTypes.SOFTPHONE;
export class TerminalTypeServiceStub implements TerminalTypeServiceInterface {
  public isTerminalTypeLoading: boolean = false;
  public isSoftPhoneInfoLoading: boolean = false;
  public softPhoneInfo: SoftPhoneInfoData | null = null;

  constructor() {
    makeAutoObservable(this);
  }

  public setTerminalType = () => {
    this.isTerminalTypeLoading = true;
  };

  public resetSoftPhonePassword = () => {
    if (this.softPhoneInfo) {
      this.softPhoneInfo.password = newPasswordStub.password;
    }
  };

  public getSoftPhoneInfo = () => {
    this.softPhoneInfo = sofftPhoneInfoStub;
  };
}
