import { makeAutoObservable } from 'mobx';
import { jsonApiCall } from 'api/common';
import {
  TerminalTypes,
  SoftPhoneInfoData,
  TerminalTypeServiceInterface,
} from './TerminalTypeService.types';
import {
  TERMINAL_URL,
  RESET_PASSWORD_URL,
  TERMINAL_SOFTPHONE_URL,
} from './TerminalTypeService.constants';

export class TerminalTypeService implements TerminalTypeServiceInterface {
  public isTerminalTypeLoading: boolean = false;
  public isSoftPhoneInfoLoading: boolean = false;
  public softPhoneInfo: SoftPhoneInfoData | null = null;

  constructor() {
    makeAutoObservable(this);
  }

  public setTerminalType = (terminalType: TerminalTypes) => {
    if (window.confirm('После изменения терминала страница будет перезагружена. Продолжить?')) {
      this.isTerminalTypeLoading = true;
      jsonApiCall({
        url: TERMINAL_URL,
        data: { terminalType },
      })
        .then(() => {
          window.location.reload();
        })
        .finally(() => {
          this.isTerminalTypeLoading = false;
        });
    }
  };

  public resetSoftPhonePassword = () => {
    this.isSoftPhoneInfoLoading = true;
    jsonApiCall({
      url: RESET_PASSWORD_URL,
    })
      .then(({ password }) => {
        if (this.softPhoneInfo) {
          this.softPhoneInfo.password = password;
        }
      })
      .finally(() => {
        this.isSoftPhoneInfoLoading = false;
      });
  };

  public getSoftPhoneInfo = () => {
    this.isSoftPhoneInfoLoading = true;
    jsonApiCall({
      url: TERMINAL_SOFTPHONE_URL,
      method: 'GET',
    })
      .then((softPhoneInfo) => {
        this.softPhoneInfo = softPhoneInfo;
      })
      .finally(() => {
        this.isSoftPhoneInfoLoading = false;
      });
  };
}
