export enum TerminalTypes {
  WEBPHONE = 'WEBPHONE',
  SOFTPHONE = 'SOFTPHONE',
}

export interface SoftPhoneInfoData {
  login: string;
  password: string;
  tcpPort: number;
  tlsPort: number;
  host: string;
}

export interface TerminalTypeServiceInterface {
  isTerminalTypeLoading: boolean;
  isSoftPhoneInfoLoading: boolean;
  softPhoneInfo: SoftPhoneInfoData | null;
  setTerminalType: (terminalType: TerminalTypes) => void;
  resetSoftPhonePassword: () => void;
  getSoftPhoneInfo: () => void;
}
