import * as t from './actionTypes.js';
import { baseCallApi, jsonApiCall } from 'api/common';

const TEMPLATES_RESET = t.TEMPLATES_RESET;
export const resetTemplates = () => ({
  type: TEMPLATES_RESET,
});

const LIST_REQUEST = t.TEMPLATES_LIST + '_REQUEST';
const LIST_RECIEVE = t.TEMPLATES_LIST + '_RECIEVE';
const LIST_FAIL = t.TEMPLATES_LIST + '_FAIL';
export const loadTemplates = () => ({
  type: 'PROMISE',
  actions: [LIST_REQUEST, LIST_RECIEVE, LIST_FAIL],
  promise: baseCallApi({
    url: '/view/usersettings/mailtemplate/list',
    host: CRM_SPACE_API_HOST,
  }),
});

const TEMPLATE_RESET = t.TEMPLATE_RESET;
export const resetTemplate = () => ({
  type: TEMPLATE_RESET,
});

const TEMPLATE_ADD = t.TEMPLATE_ADD;
export const addTemplate = () => ({
  type: TEMPLATE_ADD,
});

const TEMPLATE_GET_REQUEST = t.TEMPLATE_EDIT + '_REQUEST';
const TEMPLATE_GET_RECIEVE = t.TEMPLATE_EDIT + '_RECIEVE';
const TEMPLATE_GET_FAIL = t.TEMPLATE_EDIT + '_FAIL';
export const loadTemplate = templateId => ({
  type: 'PROMISE',
  actions: [TEMPLATE_GET_REQUEST, TEMPLATE_GET_RECIEVE, TEMPLATE_GET_FAIL],
  promise: baseCallApi({
    url: '/view/usersettings/mailtemplate/',
    host: CRM_SPACE_API_HOST,
    data: { templateId },
  }),
});

const TEMPLATE_POST_REQUEST = t.TEMPLATE_SAVE + '_REQUEST';
const TEMPLATE_POST_RECIEVE = t.TEMPLATE_SAVE + '_RECIEVE';
const TEMPLATE_POST_FAIL = t.TEMPLATE_SAVE + '_FAIL';
export const saveTemplate = data => ({
  type: 'PROMISE',
  actions: [TEMPLATE_POST_REQUEST, TEMPLATE_POST_RECIEVE, TEMPLATE_POST_FAIL],
  promise: jsonApiCall({
    url: '/actions/usersettings/mailtemplate/save',
    host: CRM_SPACE_API_HOST,
    type: 'post',
    data,
  }),
  args: data,
});

const TEMPLATE_DELETE_REQUEST = t.TEMPLATE_DELETE + '_REQUEST';
const TEMPLATE_DELETE_RECIEVE = t.TEMPLATE_DELETE + '_RECIEVE';
const TEMPLATE_DELETE_FAIL = t.TEMPLATE_DELETE + '_FAIL';
export const deleteTemplate = templateId => ({
  type: 'PROMISE',
  actions: [TEMPLATE_DELETE_REQUEST, TEMPLATE_DELETE_RECIEVE, TEMPLATE_DELETE_FAIL],
  promise: baseCallApi({
    url: '/actions/usersettings/mailtemplate/delete',
    host: CRM_SPACE_API_HOST,
    type: 'post',
    data: { templateId },
  }),
});
