import React from 'react';
import PropTypes from 'prop-types';
import RouterLink from 'components/RouterLink';
import { MODULE_NAME as SettingsModule } from 'modules/settings/constants';
import { MODULE_NAME } from 'modules/settings/modules/templates/constants';
import createI18N from '@yandex-int/i18n';
import * as keyset from './Layout.i18n';
import { ROUTE } from '../../constants';
import Templates from '../../containers/TemplatesList';
import Tip from '../Tip';
import css from './styles.modules.scss';

const i18nNewTemplate = createI18N(keyset)('newTemplate');

const SettingsTemplatesLayout = props => {
  const { templates, template, children } = props;
  const { isNew } = template;
  const { isEdit } = template;

  return (
    <div className={css.root}>
      <div className={css.aside}>
        <div className={css.templates}>
          <div className={css.header}>
            <div className={css.title}>{MODULE_NAME}</div>
            <RouterLink className={css.add} activeClassName={css.addActive} to={`${ROUTE}/new`}>
              <i className="material-icons">add_box</i>
              {i18nNewTemplate}
            </RouterLink>
          </div>
          <Templates />
        </div>
      </div>
      <div className={css.main}>
        <div className={css.path}>
          {SettingsModule} → {MODULE_NAME}
          {isNew && (
            <span>
              {' '}
              → <span className={css.isNew}>{i18nNewTemplate}</span>
            </span>
          )}
          {isEdit && template.data && template.data.name && <span> → {template.data.name}</span>}
        </div>
        {children}
        <Tip templates={templates} template={template} />
      </div>
    </div>
  );
};

SettingsTemplatesLayout.propTypes = {
  template: PropTypes.shape({
    data: PropTypes.instanceOf(Object),
  }),
  templates: PropTypes.shape({
    data: PropTypes.shape({
      private: PropTypes.arrayOf(PropTypes.object),
      common: PropTypes.arrayOf(PropTypes.object),
    }),
  }),
};

SettingsTemplatesLayout.defaultProps = {
  template: {},
  templates: {
    data: {
      common: [],
      private: [],
    },
  },
};

export default SettingsTemplatesLayout;
