import React from 'react';
import PropTypes from 'prop-types';
import { Field } from 'redux-form';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import AttachFiles from 'lego/redux-form/AttachFiles';
import cx from 'classnames';
import Suggest from 'lego/redux-form/SuggestStaffInline2';
import Button from '@crm/components/dist/lego2/Button';
import RichTextEditor from 'lego/redux-form/RichTextEditor';
import TextInput from 'lego/redux-form/TextInput';
import Toolbar from 'components/Toolbar';
import * as keyset from './TemplateForm.i18n';
import css from './styles.modules.scss';

const i18n = createI18N(keyset);
const commonI18n = createI18N(commonKeyset);
const i18nTemplateName = i18n('templateName');
const i18nGrants = i18n('grants');
const i18nTemplate = i18n('template');
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');
const i18nRemove = commonI18n('remove');

const SettingsTemplateForm = (props) => {
  const { handleSubmit, submitting, invalid, name, onReset, onDelete, form } = props;

  const { templateId } = props.initialValues;

  return (
    <form className={css.form} onSubmit={handleSubmit}>
      <div className={css.block}>
        <label htmlFor="name" className={cx(css.label, css.requiredStar)}>
          {i18nTemplateName}
        </label>
        <Field name="name" id="name" component={TextInput} className={css.title} size="m" />
      </div>
      <div className={css.row}>
        <label
          htmlFor="grants"
          className={cx(css.label, css.requiredStar)}
          style={{ whiteSpace: 'nowrap' }}
        >
          <span>{i18nGrants}</span>
        </label>
        <div className={css.field}>
          <Field
            name="grants"
            id="grants"
            className={css.grants}
            component={Suggest}
            variant={Suggest.StaffSuggestVariant.All}
            onlyUserActive
            props={{
              displayError: true,
              isNew: !templateId,
            }}
          />
        </div>
      </div>
      <div className={css.block}>
        <label htmlFor="body" className={cx(css.label, css.requiredStar)}>
          {i18nTemplate}
        </label>
        <div className={css.editor}>
          <Field
            name="body"
            id="body"
            component={RichTextEditor}
            config="mail"
            props={{
              height: 'fix',
            }}
          />
        </div>
        <Field
          name="files"
          component={AttachFiles}
          className={css.files}
          objectName="template"
          objId={templateId}
        />
      </div>
      <div className={css.actions}>
        <Toolbar>
          <Button type="submit" view="action" disabled={submitting || invalid}>
            {i18nSave}
          </Button>
          <Button view="pseudo" disabled={submitting} onClick={onReset}>
            {i18nCancel}
          </Button>
        </Toolbar>
        {templateId && (
          <Button
            view="pseudo"
            disabled={submitting}
            onClick={() => {
              onDelete(name);
            }}
          >
            {i18nRemove}
          </Button>
        )}
      </div>
    </form>
  );
};

SettingsTemplateForm.propTypes = {
  onSubmit: PropTypes.func.isRequired,
  onDelete: PropTypes.func,
  onReset: PropTypes.func,
};

SettingsTemplateForm.defaultProps = {
  onDelete: () => {},
  onReset: () => {},
};

export default SettingsTemplateForm;
