import React from 'react';
import PropTypes from 'prop-types';
import { safeGetRegV } from 'utils/safeGetRegV';
import RouterLink from 'components/RouterLink';
import Select from 'components/Select';
import { ROUTE } from '../../constants';
import css from './styles.modules.scss';

const SettingsTemplatesTypeList = (props) => {
  const { title, items, val } = props;

  if (!items.length) {
    return null;
  }

  return (
    <div className={css.group}>
      <div className={css.groupHeader}>
        <div className={css.groupTitle}>{title}</div>
      </div>
      {items.map((item) => {
        let found;
        if (val.length) found = item.name.search(safeGetRegV(val));

        if (!val.length || (val.length && found > -1)) {
          return (
            <RouterLink
              key={item.id}
              className={css.listItem}
              activeClassName={css.listItemCurrent}
              to={`${ROUTE}/${item.id}`}
            >
              <Select value={item.name} range={found > -1 ? [found, found + val.length] : null} />
            </RouterLink>
          );
        }

        return null;
      })}
    </div>
  );
};

SettingsTemplatesTypeList.propTypes = {
  title: PropTypes.string,
  items: PropTypes.arrayOf(PropTypes.object),
  val: PropTypes.string,
};

SettingsTemplatesTypeList.defaultProps = {
  title: undefined,
  items: undefined,
  val: undefined,
};

export default SettingsTemplatesTypeList;
