import React, { Component } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Empty from 'components/Empty';
import * as keyset from './TemplatesList.i18n';
import List from './List';
import css from './styles.modules.scss';

const i18n = createI18N(keyset);
const i18nSearch = i18n('search');
const i18nNoTemplates = i18n('noTemplates');
const i18nMyTemplates = i18n('myTemplates');
const i18nCommonTemplates = i18n('commonTemplates');

export default class SettingsTemplatesList extends Component {
  constructor(props) {
    super(props);

    this.state = {
      searchVal: '',
    };
  }

  handleChange = (value) => {
    this.setState({
      searchVal: value,
    });
  };

  render() {
    const { private: privateTpl, common: commonTpl } = this.props.items;
    const val = this.state.searchVal;
    const isEmpty = !privateTpl.length && !commonTpl.length;

    return (
      <div className={css.root}>
        <form className={css.search}>
          <Textinput
            className={css.searchInput}
            placeholder={i18nSearch}
            size="s"
            value={this.state.searchVal}
            onChange={this.handleChange}
          />
        </form>
        <div className={cx(css.list, isEmpty ? css.empty : null)}>
          {isEmpty && <Empty className={css.empty} text={i18nNoTemplates} icon={null} />}
          <List title={i18nMyTemplates} items={privateTpl} val={val} />
          <List title={i18nCommonTemplates} items={commonTpl} val={val} />
        </div>
      </div>
    );
  }
}

SettingsTemplatesList.propTypes = {
  items: PropTypes.shape({
    private: PropTypes.arrayOf(PropTypes.object),
    common: PropTypes.arrayOf(PropTypes.object),
  }),
};

SettingsTemplatesList.defaultProps = {
  items: {},
};
