import React from 'react';
import PropTypes from 'prop-types';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import RouterLink from 'components/RouterLink';
import * as keyset from './Tip.i18n';
import { ROUTE } from '../../constants';
import css from '../Layout/styles.modules.scss';

const i18n = createI18N(keyset);
const i18nRaw = createI18NRaw(keyset);
const i18nSomethingGoesWrong = createI18N(commonKeyset)('somethingGoesWrong');
const i18nAddNew1 = i18n('addNew', { count: 1 });
const i18nAddNew2 = i18n('addNew', { count: 2 });
const i18nNoTemplatesYet = i18nRaw('noTemplatesYet', {
  optionalAction: <RouterLink to={`${ROUTE}/new`}>{i18nAddNew1}</RouterLink>,
});
const i18nChooseTemplate = i18nRaw('chooseTemplate', {
  optionalAction: <RouterLink to={`${ROUTE}/new`}>{i18nAddNew2}</RouterLink>,
});

const SettingsTemplatesTip = props => {
  const { templates, template } = props;
  const templatesItems = templates.data;

  if (!templates.isLoad) return null;
  if (!template.isNew && (template.isError || templates.isError)) {
    return <div className={css.tip}>{i18nSomethingGoesWrong}</div>;
  }
  if (
    !template.isEdit &&
    !template.isNew &&
    !templatesItems.common.length &&
    !templatesItems.private.length
  ) {
    return <div className={css.tip}>{i18nNoTemplatesYet}</div>;
  }
  if (template.isSave && !template.data.templateId) {
    return (
      <div className={css.tip}>{i18n('templateCreated', { templateName: template.data.name })}</div>
    );
  }
  if (template.isSave) {
    return (
      <div className={css.tip}>{i18n('templateSaved', { templateName: template.data.name })}</div>
    );
  }
  if (template.isDelete) {
    return (
      <div className={css.tip}>{i18n('templateRemoved', { templateName: template.data.name })}</div>
    );
  }
  if (!template.isEdit && !template.isNew) {
    return <div className={css.tip}>{i18nChooseTemplate}</div>;
  }
  return null;
};

SettingsTemplatesTip.propTypes = {
  template: PropTypes.shape({
    data: PropTypes.instanceOf(Object),
  }),
  templates: PropTypes.shape({
    data: PropTypes.shape({
      private: PropTypes.arrayOf(PropTypes.object),
      common: PropTypes.arrayOf(PropTypes.object),
    }),
  }),
};

SettingsTemplatesTip.defaultProps = {
  template: {},
  templates: {
    data: {
      common: [],
      private: [],
    },
  },
};

export default SettingsTemplatesTip;
