import { connect } from 'react-redux';
import { reduxForm, formValueSelector } from 'redux-form';
import { toGrantAdapter } from 'lego/components/SuggestStaff';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import * as keyset from '../templates.i18n';
import { ROUTE } from '../constants';
import * as actions from '../actions';
import TemplateForm from '../components/TemplateForm';

const i18n = createI18N(keyset);
const i18nRequired = createI18N(commonKeyset)('inputRequired');

const validate = values => {
  const errors = {};
  const requiredFields = ['name', 'body'];

  requiredFields.forEach(field => {
    if (!values[field] || (values[field].hasOwnProperty('length') && !values[field].length)) {
      errors[field] = i18nRequired;
    }
  });

  if (!values.grants || !values.grants.length) {
    errors.grants = { _error: i18nRequired };
  }

  return errors;
};

const mapState = (state, props) => {
  const formName = props.form;
  const selector = formValueSelector(formName);
  const name = selector(state, 'name');

  return {
    name,
  };
};

const mapDispatch = (dispatch, props) => {
  const loadTemplates = () => dispatch(actions.loadTemplates());
  const { router } = props;

  return {
    onSubmit: data => {
      const initialGrants = (props.initialValues.grants || []).map(toGrantAdapter);
      const grants = data.grants.map(toGrantAdapter);

      initialGrants &&
        initialGrants.forEach(item => {
          const grantIsPresent = grants.some(
            i =>
              (item.userId && item.userId === i.userId) ||
              (item.groupId && item.groupId === i.groupId),
          );

          if (!grantIsPresent) {
            item.hasRemoved = true;
            grants.push(item);
          }
        });

      dispatch(
        actions.saveTemplate({
          ...data,
          grants,
        }),
      ).then(response => {
        if (response.success === true) {
          loadTemplates().then(() => {
            router.push(ROUTE);
          });
        }
      });
    },
    onDelete: name => {
      const { templateId } = props;
      const result = confirm(i18n('removeConfirm', { name }));

      if (!templateId || !result) return;

      dispatch(actions.deleteTemplate(templateId)).then(response => {
        if (response.success === true) {
          loadTemplates().then(() => {
            router.push(ROUTE);
          });
        }
      });
    },
    onReset: () => {
      dispatch(actions.resetTemplate());
      router.push(ROUTE);
    },
  };
};

export default connect(mapState, mapDispatch)(reduxForm({ validate })(TemplateForm));
