import React, { Component } from 'react';
import { withRouter } from 'react-router-dom';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { NAME } from '../constants';
import * as actions from '../actions';
import TemplatesList from '../components/TemplatesList';

const mapState = state => ({
  templates: get(state, `${NAME}.templates`),
});

const mapDispatch = dispatch => ({
  loadTemplates: () => dispatch(actions.loadTemplates()),
  resetTemplates: () => dispatch(actions.resetTemplates()),
});

class SettingsTemplatesList extends Component {
  componentWillMount() {
    this.props.loadTemplates();
  }

  componentWillUnmount() {
    this.props.resetTemplates();
  }

  render() {
    const { templates } = this.props;

    if (!templates.isLoad) return null;

    return <TemplatesList items={templates.data} />;
  }
}

export default withRouter(connect(mapState, mapDispatch)(SettingsTemplatesList));
